<?php



$finder = Symfony\Component\Finder\Finder::create()

    ->in([

        __DIR__ . '/src',

        __DIR__ . '/tests',

    ])

    ->name('*.php')

    ->ignoreDotFiles(true)

    ->ignoreVCS(true);



return (new PhpCsFixer\Config())

    ->setRules([

        '@PSR12' => true,

        'array_syntax' => ['syntax' => 'short'],

        'ordered_imports' => ['sort_algorithm' => 'alpha'],

        'no_unused_imports' => true,

        'not_operator_with_successor_space' => true,

        'trailing_comma_in_multiline' => true,

        'ternary_to_null_coalescing' => true,

        'phpdoc_scalar' => true,

        'unary_operator_spaces' => true,

        'binary_operator_spaces' => true,

        'blank_line_before_statement' => [

            'statements' => ['break', 'continue', 'declare', 'return', 'throw', 'try'],

        ],

        'phpdoc_single_line_var_spacing' => true,

        'phpdoc_var_without_name' => true,

        'class_attributes_separation' => [

            'elements' => ['const' => 'one', 'method' => 'one', 'property' => 'one', 'trait_import' => 'none', 'case' => 'none'],

        ],

    ])

    ->setFinder($finder);

