<?php
namespace HaoZiTeam\AIPost\Handler;

use HaoZiTeam\AIPost\Service\Features\HtmlUtils;

class ContentHandler {
    public static function process($post_id, $settings) {
        $post = get_post($post_id);
        $content = $post->post_content;

        // 空内容处理（使用更健壮的判空逻辑，保留<img>不视为空）
        if (HtmlUtils::is_content_effectively_empty($content)) {
            $action = $settings['empty-content-action'] ?? 'draft';
            wp_update_post([
                'ID' => $post_id,
                'post_status' => $action
            ]);
            return false;
        }

        // 内容替换
        if (!empty($settings['content-replace-rules'])) {
            $rules = explode("\n", $settings['content-replace-rules']);
            foreach ($rules as $rule) {
                list($search, $replace) = explode('=>', $rule."=>");
                $content = str_replace(trim($search), trim($replace), $content);
            }
            wp_update_post([
                'ID' => $post_id,
                'post_content' => $content
            ]);
        }
        return true;
    }
}