<?php

namespace HaoZiTeam\AIPost\Service;

defined( 'ABSPATH' ) || exit;

use YahnisElsts\PluginUpdateChecker\v5\PucFactory;
use const HaoZiTeam\AIPost\PLUGIN_FILE;

class Update {

	private $settings;
	private $updateChecker;

	public function __construct() {
		$this->settings      = get_option( 'ai-post' );
		$this->updateChecker = PucFactory::buildUpdateChecker(
			'https://auth.haozi.net/api/v1/getUpdate',
			PLUGIN_FILE,
			'ai-post'
		);
		$this->updateChecker->addQueryArgFilter( [ $this, 'update_query_args' ] );
	}

	/**
	 * 更新参数
	 *
	 * @param $query_args
	 *
	 * @return mixed
	 */
	public function update_query_args( $query_args ) {
		$query_args['product_id'] = '2';
		$query_args['auth_id']    = $this->settings['auth-id'] ?? null;
		$query_args['sign']       = md5( sprintf( 'id=%s&key=%s', strtoupper( $this->settings['auth-id'] ?? null ), strtoupper( $this->settings['auth-key'] ?? null ) ) );
		$query_args['php']        = substr( phpversion(), 0, 3 );

		return $query_args;
	}
}
