<?php

namespace HaoZiTeam\AIPost\Service\Settings\Traits;

defined('ABSPATH') || exit;

trait TraitVersionInfo
{
    /**
     * 构建设置页底部版本文本（包含远程版本获取与缓存）。
     * 行为保持与原 Setting.php 一致：
     * - 本地版本：常量 HAOZI_AIPOST_VERSION 不存在时回退到固定默认值。
     * - 远程版本：使用 transient `ai_post_remote_version` 缓存 6 小时；请求超时 10s，sslverify=false（保持现有行为）。
     */
    private function build_version_footer_text(): string
    {
        // 本地版本
        $local_version = defined('HAOZI_AIPOST_VERSION') ? HAOZI_AIPOST_VERSION : '2.7.7';

        // 远程版本（带缓存）
        $remote_data = get_transient('ai_post_remote_version');
        if (false === $remote_data) {
            $response = wp_remote_get('https://version.suqianweb.cn/update.json', [
                'timeout'   => 10,
                'sslverify' => false,
            ]);
            if (!is_wp_error($response) && 200 === wp_remote_retrieve_response_code($response)) {
                $remote_data = json_decode(wp_remote_retrieve_body($response), true);
                set_transient('ai_post_remote_version', $remote_data, 6 * HOUR_IN_SECONDS);
            }
        }

        // 版本文本
        $version_text = '当前版本：' . $local_version;
        if (isset($remote_data['version'])) {
            $version_text .= ' | 最新版本：' . $remote_data['version'];
            if (version_compare($local_version, $remote_data['version'], '<')) {
                $version_text .= ' <span style="color:#46b450;font-weight:500">(有新版本可用)</span>';
            }
        }
        return $version_text;
    }
}
