<?php

namespace HaoZiTeam\AIPost\Service\Settings\Traits;

defined('ABSPATH') || exit;

trait TraitSelfDiagnose
{
    // 渲染：一键自检面板（WP‑Cron/Loopback/证书/权限）
    public function render_self_diagnose_panel(): void
    {
        $nonce = \wp_create_nonce('ai_post_self_diagnose');
        echo '<div id="aipost-self-diagnose" style="margin:12px 0;">';
        echo '<button type="button" class="button button-secondary" id="aipost-run-diagnose">一键自检</button>';
        echo '<span class="spinner" id="aipost-diagnose-spinner" style="float:none;margin-left:8px;display:none;"></span>';
        echo '<div id="aipost-diagnose-result" style="margin-top:12px;"></div>';
        echo '</div>';
        ?>
        <script>
        (function($){
            const box = $('#aipost-diagnose-result');
            const spn = $('#aipost-diagnose-spinner');
            function render(items){
                if(!Array.isArray(items)){ box.html('<div style="color:#d63638;">无效的诊断返回</div>'); return; }
                let html = '<table class="widefat striped" style="max-width:920px;">';
                html += '<thead><tr><th style="width:220px;">检查项</th><th style="width:100px;">状态</th><th>说明</th></tr></thead><tbody>';
                items.forEach(function(it){
                    const status = it.status === 'ok' ? '<span style="color:#008a20;font-weight:600;">OK</span>' : (it.status === 'warn' ? '<span style="color:#dba617;font-weight:600;">WARN</span>' : '<span style="color:#d63638;font-weight:600;">FAIL</span>');
                    html += '<tr><td>'+ (it.name||'') +'</td><td>'+ status +'</td><td>'+ (it.message||'') + (it.details? ('<pre style="white-space:pre-wrap;background:#f6f7f7;padding:8px;border:1px solid #ddd;">'+ it.details +'</pre>'):'') +'</td></tr>';
                });
                html += '</tbody></table>';
                box.html(html);
            }
            $(document).on('click', '#aipost-run-diagnose', function(){
                try{
                    console.log('[AI-Post][SelfDiagnose] click');
                }catch(_){/* noop */}
                if (typeof ajaxurl === 'undefined' || !ajaxurl) { alert('AJAX URL 未定义'); return; }
                const $btn = $(this);
                $btn.prop('disabled', true); spn.show(); box.empty();
                $.post(ajaxurl, { action: 'ai_post_self_diagnose', nonce: '<?php echo $nonce; ?>' }, function(resp){
                    try{ console.log('[AI-Post][SelfDiagnose] resp:', resp); }catch(_){}
                    if(resp && resp.success){ render(resp.data.results || []); }
                    else { box.html('<div style="color:#d63638;">自检失败: '+ (resp && resp.data && resp.data.message ? resp.data.message : '未知错误') +'</div>'); }
                }).fail(function(jq,x,e){
                    try{ console.error('[AI-Post][SelfDiagnose] ajax fail', x, e); }catch(_){}
                    box.html('<div style="color:#d63638;">请求失败: '+ x +' '+ e +'</div>');
                }).always(function(){ $btn.prop('disabled', false); spn.hide(); });
            });
        })(jQuery);
        </script>
        <?php
    }

    // 在 admin_init 时（按 30 分钟节流）输出一次 CA 相关配置到 debug.log，便于对齐排查。
    // 行为与 Setting::admin_init 内原实现保持一致。
    public function maybe_log_ca_status_on_admin_init(): void
    {
        $ca_throttle_key = 'aipost_admin_init_ca_log_last';
        $should_log_ca = true;
        if (function_exists('get_transient')) {
            $should_log_ca = !get_transient($ca_throttle_key);
        }
        if (!$should_log_ca) { return; }

        try {
            // 可靠地从当前文件路径推导插件根目录：.../wp-content/plugins/ai-post/
            $plugin_root = dirname(__DIR__, 3);
            if (!is_dir($plugin_root)) {
                $plugin_root = dirname(__FILE__, 5);
            }
            $cacertPath = rtrim($plugin_root, '/\\') . DIRECTORY_SEPARATOR . 'resources' . DIRECTORY_SEPARATOR . 'cacert.pem';
            $iniCurl = ini_get('curl.cainfo');
            $iniOpen = ini_get('openssl.cafile');
            $readable  = is_readable($cacertPath) ? 'yes' : 'no';
            $size      = @filesize($cacertPath);
            error_log(sprintf(
                'AI Post SSL: 当前 CA 配置: curl.cainfo=%s; openssl.cafile=%s; plugin_cacert=%s (readable=%s, size=%s bytes)',
                empty($iniCurl) ? 'empty' : $iniCurl,
                empty($iniOpen) ? 'empty' : $iniOpen,
                $cacertPath,
                $readable,
                $size !== false ? (string)$size : 'unknown'
            ));
            if (function_exists('set_transient')) {
                set_transient($ca_throttle_key, time(), 30 * MINUTE_IN_SECONDS);
            }
        } catch (\Throwable $e) {
            error_log('AI Post SSL: 初始化阶段输出 CA 配置失败: ' . $e->getMessage());
        }
    }

    // 一键自检：WP-Cron/Loopback/证书/权限/任务注册等
    public function ajax_self_diagnose(): void
    {
        try {
            if (!isset($_POST['nonce']) || !\wp_verify_nonce($_POST['nonce'], 'ai_post_self_diagnose')) {
                \wp_send_json_error(['message' => 'Nonce 验证失败'], 403);
            }
            if (!\current_user_can('manage_options')) {
                \wp_send_json_error(['message' => '权限不足'], 403);
            }

            $results = [];

            // 1) WP-Cron 开关
            $wp_cron_disabled = defined('DISABLE_WP_CRON') && DISABLE_WP_CRON;
            $results[] = [
                'name' => 'WP-Cron 开关 (DISABLE_WP_CRON)',
                'status' => $wp_cron_disabled ? 'warn' : 'ok',
                'message' => $wp_cron_disabled ? 'WP-Cron 被禁用，请使用系统 crontab 触发 /wp-cron.php 或开启 WP-Cron' : 'WP-Cron 未被禁用'
            ];

            // 2) Loopback: 请求 /wp-cron.php
            $cron_url = home_url('/wp-cron.php?doing_wp_cron');
            $resp = function_exists('wp_remote_get') ? wp_remote_get($cron_url, ['timeout' => 10]) : null;
            $http_code = is_wp_error($resp) ? 0 : (wp_remote_retrieve_response_code($resp) ?: 0);
            $results[] = [
                'name' => 'Loopback (wp-cron.php)',
                'status' => ($http_code >= 200 && $http_code < 400) ? 'ok' : 'fail',
                'message' => $http_code ? ('HTTP ' . $http_code) : '请求失败',
                'details' => is_wp_error($resp) ? $resp->get_error_message() : ''
            ];

            // 3) WP-Cron 队列中是否存在 ai_post_cron
            $has_scheduled = false; $scheduled_keys = [];
            $settings = get_option('ai-post');
            if (!empty($settings['tasks']) && is_array($settings['tasks'])) {
                foreach ($settings['tasks'] as $k => $task) {
                    if (!empty($task['task-status'])) {
                        if (wp_next_scheduled('ai_post_cron', [$k])) { $has_scheduled = true; $scheduled_keys[] = (string)$k; }
                    }
                }
            }
            $results[] = [
                'name' => 'WP-Cron 队列 (ai_post_cron)',
                'status' => $has_scheduled ? 'ok' : 'warn',
                'message' => $has_scheduled ? ('已排队任务: ' . implode(',', $scheduled_keys)) : '未发现已排队的 ai_post_cron 事件，可能尚未注册或任务均未启用',
            ];

            // 4) 任务配置有效性
            $enabled_count = 0; $task_count = 0;
            if (!empty($settings['tasks']) && is_array($settings['tasks'])) {
                $task_count = count($settings['tasks']);
                foreach ($settings['tasks'] as $task) { if (!empty($task['task-status'])) $enabled_count++; }
            }
            $results[] = [
                'name' => '任务配置（总数/启用）',
                'status' => ($task_count>0 && $enabled_count>0) ? 'ok' : 'warn',
                'message' => sprintf('任务总数: %d，已启用: %d', $task_count, $enabled_count)
            ];

            // 5) cron_lock
            $cron_lock = get_option('cron_lock');
            $results[] = [
                'name' => 'WP Cron Lock',
                'status' => empty($cron_lock) ? 'ok' : 'warn',
                'message' => empty($cron_lock) ? '未发现锁' : ('存在锁: ' . print_r($cron_lock, true)),
            ];

            // 6) 调试日志可写路径
            $log_target = defined('AIPOST_DEBUG_PATH') ? AIPOST_DEBUG_PATH : ABSPATH . 'debug.log';
            $fallback = WP_CONTENT_DIR . '/uploads/ai-post/logs/debug.log';
            $target = is_writable(dirname($log_target)) ? $log_target : $fallback;
            $writable = is_writable(dirname($target));
            $results[] = [
                'name' => 'debug.log 写入目录',
                'status' => $writable ? 'ok' : 'fail',
                'message' => ($writable ? '可写: ' : '不可写: ') . $target,
            ];

            // 7) CA 配置可读性
            // 修正：自检应指向“插件根/resources/cacert.pem”，而非 Service/Settings/resources
            if (defined('AIPOST_PLUGIN_PATH') && AIPOST_PLUGIN_PATH) {
                $plugin_root = rtrim(AIPOST_PLUGIN_PATH, '/\\');
            } else {
                // 从 Service/Settings/Traits 上溯三级到插件根目录
                $plugin_root = rtrim(dirname(__DIR__, 3), '/\\');
            }
            $cacertPath = $plugin_root . DIRECTORY_SEPARATOR . 'resources' . DIRECTORY_SEPARATOR . 'cacert.pem';
            $iniCurl = ini_get('curl.cainfo');
            $iniOpen = ini_get('openssl.cafile');
            $results[] = [
                'name' => 'CA 配置',
                'status' => is_readable($cacertPath) ? 'ok' : 'warn',
                'message' => sprintf('curl.cainfo=%s; openssl.cafile=%s; plugin_cacert=%s', empty($iniCurl)?'empty':$iniCurl, empty($iniOpen)?'empty':$iniOpen, $cacertPath),
                'details' => 'plugin_cacert readable='.(is_readable($cacertPath)?'yes':'no').', size='.(file_exists($cacertPath)? @filesize($cacertPath) : 'unknown')
            ];

            // 8) 时区/当前时间
            $results[] = [
                'name' => '时间/时区',
                'status' => 'ok',
                'message' => sprintf('server_time=%s; wp_time=%s; php_tz=%s', date('Y-m-d H:i:s'), current_time('Y-m-d H:i:s'), ini_get('date.timezone') ?: 'not set')
            ];

            \wp_send_json_success(['results' => $results]);
        } catch (\Throwable $e) {
            \wp_send_json_error(['message' => '异常: '.$e->getMessage()], 500);
        }
    }
}
