<?php

namespace HaoZiTeam\AIPost\Service\Settings\Traits;

defined('ABSPATH') || exit;

trait TraitAdminInjections
{
    /**
     * 在设置页页脚兜底输出“系统调试与日志”面板，
     * 仅当 CGPS 回调渲染未发生时才输出一次，避免按钮缺失。
     * 行为与 Setting::admin_init() 中原匿名闭包完全一致。
     */
    public function maybe_fallback_render_debug_panel(): void
    {
        // 仅限本插件设置页
        if (!isset($_GET['page']) || $_GET['page'] !== 'ai-post') { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
            return;
        }
        // 依赖 Setting::$debug_panel_rendered 标识（由面板回调置位）
        if (property_exists($this, 'debug_panel_rendered') && !$this->debug_panel_rendered) {
            if (method_exists($this, 'render_debug_log_panel')) {
                $this->render_debug_log_panel();
            }
        }
    }
}
