<?php

namespace HaoZiTeam\AIPost\Service\Features;

defined('ABSPATH') || exit;

/**
 * 文心一言（千帆）模型能力目录：提供每个模型的最大输出限制与优势描述。
 * 注意：max_output_tokens 官方文档常见可配范围为 2-2048（不同模型/时期可能调整）。
 * 这里采用稳健的上限 2048，并预留占位，后续可根据官方文档更新。
 */
class WenXinModelCatalog
{
    /**
     * 获取模型能力映射表。
     * key: 账户设置中使用的小写模型名（与 Setting.php 选项一致）
     */
    public static function get(): array
    {
        return [
            'ernie-4.0-8k' => [
                'display' => 'ERNIE-4.0-8K（推荐）',
                'max_output_tokens' => 2048,
                'advantages' => '综合能力最强，推理创作更可靠；约8K上下文，适合高质量长文生成。',
            ],
            'ernie-3.5-8k' => [
                'display' => 'ERNIE-3.5-8K（均衡）',
                'max_output_tokens' => 2048,
                'advantages' => '成本与效果均衡，适合日常内容生成与改写。',
            ],
            'ernie-speed-8k' => [
                'display' => 'ERNIE-Speed-8K（更快）',
                'max_output_tokens' => 2048,
                'advantages' => '响应更快，适合批量生产与对实时性要求较高的场景。',
            ],
            'ernie-lite-8k' => [
                'display' => 'ERNIE-Lite-8K（轻量）',
                'max_output_tokens' => 2048,
                'advantages' => '轻量高效，性价比优，适合简单长文或摘要改写。',
            ],
        ];
    }

    /**
     * 根据模型名获取最大输出上限。
     */
    public static function maxOutputFor(string $model): int
    {
        $m = strtolower(trim($model));
        $map = self::get();
        if (isset($map[$m]['max_output_tokens'])) {
            return (int) $map[$m]['max_output_tokens'];
        }
        // 未知模型：回退到安全上限 2048
        return 2048;
    }

    /**
     * 生成设置页下拉选项：将最大输出与优势拼入展示文本。
     */
    public static function optionsForSelect(): array
    {
        $opts = [];
        foreach (self::get() as $key => $info) {
            $label = $info['display'];
            $max = (int) ($info['max_output_tokens'] ?? 2048);
            $adv = (string) ($info['advantages'] ?? '');
            $opts[$key] = sprintf('%s｜最大输出≈%d tokens｜%s', $label, $max, $adv);
        }
        return $opts;
    }
}
