<?php
// Service/Features/TimeUtils.php
// 该文件主要负责提供时间相关的辅助功能，例如时间转换和时间段判断。

namespace HaoZiTeam\AIPost\Service\Features;

defined('ABSPATH') || exit;

class TimeUtils
{
    /**
     * 将时间字符串 (HH:MM) 转换为分钟数。
     *
     * @param string $time 时间字符串，格式为 HH:MM。
     * @return int 总分钟数。
     */
    public static function time_to_minutes($time)
    {
        list($hours, $minutes) = explode(':', $time);
        return (intval($hours) * 60) + intval($minutes);
    }

    /**
     * 检查当前时间是否在给定的时间段内。
     *
     * @param string $current 当前时间 (HH:MM)。
     * @param string $start 开始时间 (HH:MM)。
     * @param string $end 结束时间 (HH:MM)。
     * @return bool 如果当前时间在时间段内，则返回 true，否则返回 false。
     */
    public static function is_time_between($current, $start, $end)
    {
        // 将时间转换为分钟数进行比较
        $current_minutes = self::time_to_minutes($current);
        $start_minutes = self::time_to_minutes($start);
        $end_minutes = self::time_to_minutes($end);
        
        // 处理跨天的情况
        if ($end_minutes < $start_minutes) {
            return $current_minutes >= $start_minutes || $current_minutes <= $end_minutes;
        }
        
        return $current_minutes >= $start_minutes && $current_minutes <= $end_minutes;
    }
} 