<?php

namespace HaoZiTeam\AIPost\Service\Features;

defined('ABSPATH') || exit;

/**
 * 安全设置读取工具：与 SettingsEndpoint 的加密方式保持一致
 * - 选项名：ai-post-secure
 * - 值格式：明文或以 enc:: 前缀的 AES-256-CBC 文本
 */
class SecureSettings
{
    public const OPTION = 'ai-post-secure';

    /**
     * 读取指定键名的值（自动解密）。
     * @param string $key 例如 openai_key / custom_key / deepseek_key / doubao_key / bailian_key / wenxin_key
     * @return string|null 解密后的明文；不存在返回 null
     */
    public static function get(string $key): ?string
    {
        $all = get_option(self::OPTION, []);
        if (!is_array($all) || !array_key_exists($key, $all)) {
            return null;
        }
        $val = (string)$all[$key];
        return self::decrypt_value($val);
    }

    /**
     * 解密与 SettingsEndpoint::encrypt_value 对应的值
     */
    private static function decrypt_value(string $val): string
    {
        if (strpos($val, 'enc::') !== 0) {
            return $val; // 明文
        }
        $enc = substr($val, 5);
        $key = defined('AUTH_KEY') && AUTH_KEY ? AUTH_KEY : (defined('SECURE_AUTH_KEY') ? SECURE_AUTH_KEY : '');
        if ($key === '') {
            // 缺少密钥时无法解密，直接返回原密文以避免数据丢失
            return $val;
        }
        $method = 'AES-256-CBC';
        $iv = substr(hash('sha256', $key . 'aipost_iv'), 0, 16);
        $out = openssl_decrypt($enc, $method, substr(hash('sha256', $key), 0, 32), 0, $iv);
        if ($out === false || $out === null) {
            return $val; // 解密失败，原样返回
        }
        return $out;
    }
}
