<?php
// Service/Features/NumberUtils.php
// 该文件主要负责提供数字处理相关的辅助功能，例如数字到中文的转换。

namespace HaoZiTeam\AIPost\Service\Features;

defined('ABSPATH') || exit;

class NumberUtils
{
    /**
     * 将数字转换为中文数字。
     *
     * @param int $num 要转换的数字。
     * @return string 中文数字或原始数字（如果映射不存在）。
     */
    public static function numberToChinese($num)
    {
        $chineseNumbers = [
            '零', '一', '二', '三', '四', '五', '六', '七', '八', '九',
            '十', '十一', '十二', '十三', '十四', '十五', '十六', '十七', '十八', '十九'
        ];
        return $chineseNumbers[$num] ?? (string)$num;
    }
} 