<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access directly.

/**

 *

 * Setup Framework Class

 *

 * @since 1.0.0

 * @version 1.0.0

 *

 */

if ( ! class_exists( 'CGPS_Welcome' ) ) {

  class CGPS_Welcome{



    private static $instance = null;



    public function __construct() {



      if ( CGPS::$premium && ( ! CGPS::is_active_plugin( 'cgps-framework/cgps-framework.php' ) || apply_filters( 'cgps_welcome_page', true ) === false ) ) { return; }



      add_action( 'admin_menu', array( $this, 'add_about_menu' ), 0 );

      add_filter( 'plugin_action_links', array( $this, 'add_plugin_action_links' ), 10, 5 );

      add_filter( 'plugin_row_meta', array( $this, 'add_plugin_row_meta' ), 10, 2 );



      $this->set_demo_mode();



    }



    // instance

    public static function instance() {

      if ( is_null( self::$instance ) ) {

        self::$instance = new self();

      }

      return self::$instance;

    }



    public function add_about_menu() {

      add_management_page( 'Cgps Framework', 'Cgps Framework', 'manage_options', 'cgps-welcome', array( $this, 'add_page_welcome' ) );

    }



    public function add_page_welcome() {



      $section = ( ! empty( $_GET['section'] ) ) ? sanitize_text_field( wp_unslash( $_GET['section'] ) ) : '';



      CGPS::include_plugin_file( 'views/header.php' );



      // safely include pages

      switch ( $section ) {



        case 'quickstart':

          CGPS::include_plugin_file( 'views/quickstart.php' );

        break;



        case 'documentation':

          CGPS::include_plugin_file( 'views/documentation.php' );

        break;



        case 'relnotes':

          CGPS::include_plugin_file( 'views/relnotes.php' );

        break;



        case 'support':

          CGPS::include_plugin_file( 'views/support.php' );

        break;



        case 'free-vs-premium':

          CGPS::include_plugin_file( 'views/free-vs-premium.php' );

        break;



        default:

          CGPS::include_plugin_file( 'views/about.php' );

        break;



      }



      CGPS::include_plugin_file( 'views/footer.php' );



    }



    public static function add_plugin_action_links( $links, $plugin_file ) {



      if ( $plugin_file === 'cgps-framework/cgps-framework.php' && ! empty( $links ) ) {

        $links['cgps--welcome'] = '<a href="'. esc_url( admin_url( 'tools.php?page=cgps-welcome' ) ) .'">Settings</a>';

        if ( ! CGPS::$premium ) {

          $links['cgps--upgrade'] = '<a href="http://cgpsframework.com/">Upgrade</a>';

        }

      }



      return $links;



    }



    public static function add_plugin_row_meta( $links, $plugin_file ) {



      if ( $plugin_file === 'cgps-framework/cgps-framework.php' && ! empty( $links ) ) {

        $links['cgps--docs'] = '<a href="http://cgpsframework.com/documentation/" target="_blank">Documentation</a>';

      }



      return $links;



    }



    public function set_demo_mode() {



      $demo_mode = get_option( 'cgps_demo_mode', false );



      $demo_activate = ( ! empty( $_GET[ 'cgps-demo' ] ) ) ? sanitize_text_field( wp_unslash( $_GET[ 'cgps-demo' ] ) ) : '';



      if ( ! empty( $demo_activate ) ) {



        $demo_mode = ( $demo_activate === 'activate' ) ? true : false;



        update_option( 'cgps_demo_mode', $demo_mode );



      }



      if ( ! empty( $demo_mode ) ) {



        CGPS::include_plugin_file( 'samples/admin-options.php' );



        if ( CGPS::$premium ) {



          CGPS::include_plugin_file( 'samples/customize-options.php' );

          CGPS::include_plugin_file( 'samples/metabox-options.php'   );

          CGPS::include_plugin_file( 'samples/nav-menu-options.php'  );

          CGPS::include_plugin_file( 'samples/profile-options.php'   );

          CGPS::include_plugin_file( 'samples/shortcode-options.php' );

          CGPS::include_plugin_file( 'samples/taxonomy-options.php'  );

          CGPS::include_plugin_file( 'samples/widget-options.php'    );

          CGPS::include_plugin_file( 'samples/comment-options.php'   );



        }



      }



    }



  }



  CGPS_Welcome::instance();

}

