<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access directly.



  $demo    = get_option( 'cgps_demo_mode', false );

  $text    = ( ! empty( $demo ) ) ? 'Deactivate' : 'Activate';

  $status  = ( ! empty( $demo ) ) ? 'deactivate' : 'activate';

  $class   = ( ! empty( $demo ) ) ? ' cgps-warning-primary' : '';

  $section = ( ! empty( $_GET[ 'section' ] ) ) ? sanitize_text_field( wp_unslash( $_GET[ 'section' ] ) ) : 'about';

  $links   = array(

    'about'           => 'About',

    'quickstart'      => 'Quick Start',

    'documentation'   => 'Documentation',

    'free-vs-premium' => 'Free vs Premium',

    'support'         => 'Support',

    'relnotes'        => 'Release Notes',

  );



?>

<div class="cgps-welcome cgps-welcome-wrap">



  <h1>Welcome to Cgps Framework v<?php echo esc_attr( CGPS::$version ); ?></h1>



  <p class="cgps-about-text">A Simple and Lightweight WordPress Option Framework for Themes and Plugins</p>



  <p class="cgps-demo-button"><a href="<?php echo esc_url( add_query_arg( array( 'cgps-demo' => $status ) ) ); ?>" class="button button-primary<?php echo esc_attr( $class ); ?>"><?php echo esc_attr( $text ); ?> Demo</a></p>



  <div class="cgps-logo">

    <div class="cgps--effects"><i></i><i></i><i></i><i></i></div>

    <div class="cgps--wp-logos">

      <div class="cgps--wp-logo"></div>

      <div class="cgps--wp-plugin-logo"></div>

    </div>

    <div class="cgps--text">Cgps Framework</div>

    <div class="cgps--text cgps--version">v<?php echo esc_attr( CGPS::$version ); ?></div>

  </div>



  <h2 class="nav-tab-wrapper wp-clearfix">

    <?php



      foreach ( $links as $key => $link ) {



        if ( CGPS::$premium && $key === 'free-vs-premium' ) { continue; }



        $activate = ( $section === $key ) ? ' nav-tab-active' : '';



        echo '<a href="'. esc_url( add_query_arg( array( 'page' => 'cgps-welcome', 'section' => $key ), admin_url( 'tools.php' ) ) ) .'" class="nav-tab'. esc_attr( $activate ) .'">'. esc_attr( $link ) .'</a>';



      }



    ?>

  </h2>

