<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access directly.

/**

 *

 * Field: icon

 *

 * @since 1.0.0

 * @version 1.0.0

 *

 */

if ( ! class_exists( 'CGPS_Field_icon' ) ) {

  class CGPS_Field_icon extends CGPS_Fields {



    public function __construct( $field, $value = '', $unique = '', $where = '', $parent = '' ) {

      parent::__construct( $field, $value, $unique, $where, $parent );

    }



    public function render() {



      $args = wp_parse_args( $this->field, array(

        'button_title' => esc_html__( 'Add Icon', 'cgps' ),

        'remove_title' => esc_html__( 'Remove Icon', 'cgps' ),

      ) );



      echo $this->field_before();



      $nonce  = wp_create_nonce( 'cgps_icon_nonce' );

      $hidden = ( empty( $this->value ) ) ? ' hidden' : '';



      echo '<div class="cgps-icon-select">';

      echo '<span class="cgps-icon-preview'. esc_attr( $hidden ) .'"><i class="'. esc_attr( $this->value ) .'"></i></span>';

      echo '<a href="#" class="button button-primary cgps-icon-add" data-nonce="'. esc_attr( $nonce ) .'">'. $args['button_title'] .'</a>';

      echo '<a href="#" class="button cgps-warning-primary cgps-icon-remove'. esc_attr( $hidden ) .'">'. $args['remove_title'] .'</a>';

      echo '<input type="hidden" name="'. esc_attr( $this->field_name() ) .'" value="'. esc_attr( $this->value ) .'" class="cgps-icon-value"'. $this->field_attributes() .' />';

      echo '</div>';



      echo $this->field_after();



    }



    public function enqueue() {

      add_action( 'admin_footer', array( 'CGPS_Field_icon', 'add_footer_modal_icon' ) );

      add_action( 'customize_controls_print_footer_scripts', array( 'CGPS_Field_icon', 'add_footer_modal_icon' ) );

    }



    public static function add_footer_modal_icon() {

    ?>

      <div id="cgps-modal-icon" class="cgps-modal cgps-modal-icon hidden">

        <div class="cgps-modal-table">

          <div class="cgps-modal-table-cell">

            <div class="cgps-modal-overlay"></div>

            <div class="cgps-modal-inner">

              <div class="cgps-modal-title">

                <?php esc_html_e( 'Add Icon', 'cgps' ); ?>

                <div class="cgps-modal-close cgps-icon-close"></div>

              </div>

              <div class="cgps-modal-header">

                <input type="text" placeholder="<?php esc_html_e( 'Search...', 'cgps' ); ?>" class="cgps-icon-search" />

              </div>

              <div class="cgps-modal-content">

                <div class="cgps-modal-loading"><div class="cgps-loading"></div></div>

                <div class="cgps-modal-load"></div>

              </div>

            </div>

          </div>

        </div>

      </div>

    <?php

    }



  }

}

