<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access directly.

/**

 *

 * Field: backup

 *

 * @since 1.0.0

 * @version 1.0.0

 *

 */

if ( ! class_exists( 'CGPS_Field_backup' ) ) {

  class CGPS_Field_backup extends CGPS_Fields {



    public function __construct( $field, $value = '', $unique = '', $where = '', $parent = '' ) {

      parent::__construct( $field, $value, $unique, $where, $parent );

    }



    public function render() {



      $unique = $this->unique;

      $nonce  = wp_create_nonce( 'cgps_backup_nonce' );

      $export = add_query_arg( array( 'action' => 'cgps-export', 'unique' => $unique, 'nonce' => $nonce ), admin_url( 'admin-ajax.php' ) );



      echo $this->field_before();



      echo '<textarea name="cgps_import_data" class="cgps-import-data"></textarea>';

      echo '<button type="submit" class="button button-primary cgps-confirm cgps-import" data-unique="'. esc_attr( $unique ) .'" data-nonce="'. esc_attr( $nonce ) .'">'. esc_html__( 'Import', 'cgps' ) .'</button>';

      echo '<hr />';

      echo '<textarea readonly="readonly" class="cgps-export-data">'. esc_attr( json_encode( get_option( $unique ) ) ) .'</textarea>';

      echo '<a href="'. esc_url( $export ) .'" class="button button-primary cgps-export" target="_blank">'. esc_html__( 'Export & Download', 'cgps' ) .'</a>';

      echo '<hr />';

      echo '<button type="submit" name="cgps_transient[reset]" value="reset" class="button cgps-warning-primary cgps-confirm cgps-reset" data-unique="'. esc_attr( $unique ) .'" data-nonce="'. esc_attr( $nonce ) .'">'. esc_html__( 'Reset', 'cgps' ) .'</button>';



      echo $this->field_after();



    }



  }

}

